﻿#	ArtLebedevStudio::RemoteTypograf.pm
#	Perl 6 implementation of ArtLebedevStudio.RemoteTypograf class (web-service client)
#	
#	Copyright (c) Art. Lebedev Studio | http://www.artlebedev.ru/
#
#	Typograf homepage: http://typograf.artlebedev.ru/
#	Web-service address: http://typograf.artlebedev.ru/webservices/typograf.asmx
#	WSDL-description: http://typograf.artlebedev.ru/webservices/typograf.asmx?WSDL
#	
#	Default charset: UTF-8
#
#	Version: 1.0 (August 30, 2005)
#	Author: Andrew Shitov (ash@design.ru)
#
#
#	Example:
#		use ArtLebedevStudio::RemoteTypograf;
#		my $remoteTypograf = new ArtLebedevStudio::RemoteTypograf;
#		say $remoteTypograf.processText("some text follows here:\n\"text\"");

class ArtLebedevStudio::RemoteTypograf
{
	has $.entityType;
	has $.useBr;
	has $.useP;
	has $.maxNobr;
	# has $.encoding;

	method BUILD ($self:)
	{
		$self.entityType = 1;
		$self.useBr = 1;
		$self.useP = 1;
		$self.maxNobr = 3;
		# $self.encoding = 'UTF-8'; # is default and only
	}

	method htmlEntities()
	{
		$.entityType = 1;
	}

	method xmlEntities()
	{
		$.entityType = 2;
	}

	method mixedEntities()
	{
		$.entityType = 4;
	}

	method noEntities()
	{
		$.entityType = 3;
	}

	method br ($value)
	{
		$.useBr = $value ?? 1 :: 0;
	}

	method p ($value)
	{
		$.useP = $value ?? 1 :: 0;
	}

	method nobr ($value)
	{
		$.maxNobr = $value ?? $value :: 0;
	}

	method processText ($text is copy)
	{
		$text ~~ s:g/&amp;/&/;
		$text ~~ s:g/&lt;/</;
		$text ~~ s:g/&gt;/>/;

		my $connection = connect 'typograf.artlebedev.ru', 80;

		my $SOAPBody = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n
				<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">
					<soap:Body>
						<ProcessText xmlns=\"http://typograf.artlebedev.ru/webservices/\">
							<text>{$text}</text>
							<entityType>{$.entityType}</entityType>
							<useBr>{$.useBr}</useBr>
							<useP>{$.useP}</useP>
							<maxNobr>{$.maxNobr}</maxNobr>
						</ProcessText>
					</soap:Body>
				</soap:Envelope>";

		my $ContentLength = $SOAPBody.bytes;
		my $header = "POST /webservices/typograf.asmx HTTP/1.1\n" ~
			"Host: typograf.artlebedev.ru\n" ~
			"Content-Type: text/xml; charset=UTF-8\n" ~
			"Content-Length: $ContentLength\n\n";

		$connection.say($header ~ $SOAPBody);
		$connection.flush;

		my $response = $connection.slurp;

		my $startsAt = $response.index('<ProcessTextResult>') + 19;
		my $endsAt = $response.index('</ProcessTextResult>');
		my $typographed = $response.substr($startsAt, $endsAt - $startsAt - 1);

		$typographed ~~ s:g/&amp;/&/;
		$typographed ~~ s:g/&lt;/</;
		$typographed ~~ s:g/&gt;/>/;

		return $typographed;
	}
}
